@if ($errors->any())
<div class="alert alert-danger">
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
<form action="{{Path::AppUrl('save-contact-us')}}" class="row g-4" method="post">
    @csrf
    
    {{-- حقول الإدخال --}}
    <div class="col-md-6">
        <input type="text" class="form-control bg-light border-0 py-3" placeholder="{{__('website.name')}}" name="name" />
    </div>
    <div class="col-md-6">
        <input type="email" class="form-control bg-light border-0 py-3" placeholder="{{__('website.email')}}" name="email" />
    </div>
    <div class="col-md-6">
        <input type="text" class="form-control bg-light border-0 py-3" placeholder="{{__('website.phone')}}" name="phone" />
    </div>
    <div class="col-md-6">
        <input type="text" class="form-control bg-light border-0 py-3" placeholder="{{__('website.company')}}" name="company" />
    </div>
    <div class="col-12">
        <textarea class="form-control bg-light border-0 py-3" rows="4" placeholder="{{__('website.message')}}" name="message"></textarea>
    </div>

    {{-- هذا الحقل هو ما سترسله للـ backend --}}
    <input type="hidden" name="g-recaptcha-response" id="recaptcha_token">

    <div class="col-12">
        <button class="btn btn-warning px-4 py-2 rounded-3 fw-semibold w-100" type="submit">
            {{__('website.send')}} <i class="fa-solid fa-paper-plane ms-2"></i>
        </button>
    </div>
</form>

<!-- <======================= EndContactForm =========================> -->
<script src="https://www.google.com/recaptcha/api.js?render={{ config('captcha.sitekey') }}"></script>

<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('{{ config('captcha.sitekey') }}', {action: 'contact'}).then(function(token) {
            document.getElementById('recaptcha_token').value = token;
        });
    });
</script>

