<!--====================Site Footer==============-->
<footer class="site-footer-custom pt-5">
    <div class="container pb-3">
        <div class="row align-items-start g-5">
            <!-- Logo -->
            <div class="col-md-3 mb-4 mb-md-0 text-center ">
                <img src="{{ Path::FooterLogo() }}" alt="Mepicom Logo" class="mb-3 w-75 logo" />
                <div class="text-start">
                    <p>{!! $site_description ?? config('configrations.site_description') !!}</p>
                </div>
                <div class="mt-4 d-flex gap-3 align-items-center icons-list-mobile">
                    <x-website.partials.social-media :socialMediaLinks="$socialMediaLinks" />
                </div>
            </div>
            <!-- Contact us -->
            <div class="col-md-4 mb-4 mb-md-0">
                <h5 class="text-white mb-4">{{ __('website.contact_us') }}</h5>
                <div class="footer-contact-box text-white fs-6">
                    <div class="mb-2 border p-3 rounded-3 d-flex  flex-column gap-2 flex-wrap">
                        <strong class="d-flex align-items-center gap-3"><i class="fa-solid fa-phone-volume fs-5"></i>
                            {{ __('website.contact_number') }}:</strong>
                        <div class="ms-5">
                            @foreach ($phones as $phone)
                                <div><a href="tel:{{ $phone->code }}{{ $phone->phone }}">{{ $phone->phone }}</a></div>
                            @endforeach
                        </div>

                    </div>
                    <div class="mb-2 border p-3 rounded-3 d-flex align-items-center gap-2 flex-wrap">
                        <strong class="d-flex align-items-center gap-3"><i class="fa-solid fa-envelope fs-5"></i>
                            {{ trans('website.email') }}:</strong>
                        <div><a
                                href="mailto:{{ config('settings.site_email') }}">{{ config('settings.site_email') }}</a>
                        </div>
                    </div>
                    <div class=" border p-3 rounded-3 d-flex align-items-center gap-2 flex-wrap">
                        <strong class="d-flex align-items-center gap-3"><i class="fa-solid fa-location-dot"></i>
                            {{ trans('website.address') }}:</strong>
                        @foreach ($site_addresses as $address)
                            <div><a href="{{ $address->map_link }}" target="_blank">{{ $address->address }}</a></div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- Useful links -->
            <div class="col-md-5 ">
                <h5 class="text-white mb-4">{{ trans('website.quick_links') }}</h5>
                <div class="footer-links-list d-flex  gap-4 align-items-md-start align-items-center flex-wrap w-100">
                    @foreach ($menus as $menu)
                        <a href="{{ $menu->link }}" class="footer-link">{{ $menu->name }}</a>
                    @endforeach
                </div>
            </div>
        </div>
        <hr class="bg-secondary opacity-50 my-4" />
        <div class="row">
            <div class="col-12 text-center">
                <p class="mb-0 text-white text-footer">
                    {!! config('configrations.site_copyright') !!}
                </p>
            </div>
        </div>
    </div>
</footer>
<!--====================Footer==============-->
