@props(['editUrl' => '#', 'deleteUrl' => '#', 'viewUrl' => null, 'modelId' => ''])

<div class="action-buttons">
    @if ($editUrl !== '#')
        <a href="{{ $editUrl }}" class="btn-action edit" title="{{ __('dashboard.edit') }}">
            <i class="fas fa-edit"></i>
        </a>
    @endif

    @if ($viewUrl)
        <a href="{{ $viewUrl }}" class="btn-action view" title="{{ __('dashboard.view') }}">
            <i class="fas fa-eye"></i>
        </a>
    @endif

    @if ($deleteUrl !== '#')
        <form action="{{ $deleteUrl }}" method="POST" class="d-inline">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn-action delete" title="{{ __('dashboard.delete') }}"
                onclick="return confirm('هل أنت متأكد من الحذف؟')">
                <i class="fas fa-trash"></i>
            </button>
        </form>
    @endif
</div>
