@props([
    'title' => 'Table',
    'createUrl' => '#',
    'data' => [],
    'columns' => [],
    'actions' => true,
    'checkboxes' => true,
    'tableId' => 'datatable-buttons',
])

<div class="container-fluid">
    <!-- Page Header -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{ $title }}</h4>

                <div class="page-title-right d-flex align-items-center">
                    <div class="btn btn-list">
                        <a href="{{ $createUrl }}" class="btn ripple btn-primary">
                            <i class="fas fa-plus-circle"></i> {{ __('dashboard.add') }}
                        </a>
                        <button id="btn_active" class="btn ripple btn-dark">
                            <i class="fas fa-eye"></i> {{ __('dashboard.publish/unpublish') }}
                        </button>
                        <button id="btn_delete" class="btn ripple btn-danger">
                            <i class="fas fa-trash"></i> {{ __('dashboard.delete') }}
                        </button>
                    </div>

                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">{{ $title }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Table -->
    <div class="row">
        <div class="col-12">
            <div class="dashboard-table-container">
                <div class="card-header">
                    <h4>{{ $title }}</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="{{ $tableId }}"
                            class="table-enhanced table-bordered dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    @if ($checkboxes)
                                        <th class="text-center" style="width: 50px;">
                                            <div class="checkbox-enhanced">
                                                <input type="checkbox" id="checkAll" class="form-check-input">
                                                <span class="checkmark"></span>
                                            </div>
                                        </th>
                                    @endif

                                    @foreach ($columns as $column)
                                        <th>{{ $column['label'] }}</th>
                                    @endforeach

                                    @if ($actions)
                                        <th>{{ __('dashboard.actions') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                {{ $slot }}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <x-dashboard.partials.datatable />
    <script>
        $(document).ready(function() {
            // تهيئة الجدول
            var table = initializeDataTable('#{{ $tableId }}');

            // تهيئة الـ checkboxes المحسنة مع تأخير
            setTimeout(function() {
                initializeEnhancedCheckboxes();
            }, 1000);

            // إعادة تهيئة الـ checkboxes عند تغيير الجدول
            table.on('draw', function() {
                setTimeout(function() {
                    initializeEnhancedCheckboxes();
                }, 100);
            });

            // حل بسيط للـ checkboxes
            $(document).on('click', '.checkbox-enhanced', function(e) {
                e.preventDefault();
                var checkbox = $(this).find('input[type="checkbox"]');
                var isChecked = checkbox.is(':checked');
                checkbox.prop('checked', !isChecked);

                if (checkbox.attr('id') === 'checkAll') {
                    $('.check-inputs').prop('checked', !isChecked);
                } else {
                    var totalCheckboxes = $('.check-inputs').length;
                    var checkedCheckboxes = $('.check-inputs:checked').length;
                    $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
                }

                // تحديث المظهر
                setTimeout(function() {
                    $('.check-inputs:checked').closest('.checkbox-enhanced').addClass('checked');
                    $('.check-inputs:not(:checked)').closest('.checkbox-enhanced').removeClass(
                        'checked');

                    if ($('#checkAll').is(':checked')) {
                        $('#checkAll').closest('.checkbox-enhanced').addClass('checked');
                    } else {
                        $('#checkAll').closest('.checkbox-enhanced').removeClass('checked');
                    }
                }, 10);
            });
        });
    </script>
    <x-dashboard.partials.delete-btn />
@endpush
