<x-website.layout>

  <!-- start banner -->
  <div class="hero-slider hero-slider-pages position-relative">
    <div class="text-slider mt-5">
      <h1 class="wow fadeInRight " data-wow-duration="1s">{{$service->name}}</h1>
      <nav aria-label=" ">
        <ol class="breadcrumb d-flex justify-content-center gap-2 align-items-center text-white mt-4">
          <li class="breadcrumb-item fs-4">
            <a href="{{ route('website.home') }}" class="text-white-50 text-decoration-none">{{ trans('website.home') }}</a>
          </li>
          <li class="fs-3">/</li>
          <li class="breadcrumb-item fw-bold active fs-4 text-white" aria-current="page">
            {{$service->name}}
          </li>
        </ol>
      </nav>
    </div>
    <div class="overlay"></div>
  </div>
  <!-- end banner -->
  <!-- start service details -->
  <section class="services-card py-5 bg-white">
    <div class="container py-5">
      <div class="row pt-5 g-5">
        <div class="col-lg-8 position-relative wow fadeInUp" data-wow-duration="1.5s">
          <div class="custom-services">
            <img src="{{ $service->image_path }}"
              class="img-fluid shadow-lg rounded-4 object-fit-cover" alt="" />
            <div class="">
              <p class="mt-3 fw-medium d-grid px-2 lh-lg">
                {!! $service->long_desc !!}
              </p>
            </div>
          </div>

        </div>
        <div class="col-lg-4">
          <div class=" wow fadeInRight" data-wow-delay="0.3s">
            <div class="other-products">
              <h3 class="mb-4 fw-bold border-bottom p-3 wow fadeInRight" data-wow-delay="0.4s">
                {{ trans('website.other_services') }}
              </h3>
              <div class="other-products-list px-3">
                @foreach ($relatedServices as $relatedService)
                <div class="d-flex mb-4 pb-2 gap-3 border-bottom wow fadeInRight" data-wow-delay="0.5s">
                  <div class="flex-shrink-0">
                    <img src="{{ $relatedService->image_path }}"
                      alt="VRF Air Conditioning System" class="rounded me-3" width="80" height="80" />
                  </div>
                  <div class="flex-grow-1 d-grid justify-content-between">
                    <h5 class="mb-2">
                      <a href="{{ $relatedService->link }}" class="text-decoration-none fw-semibold fs-6">
                        {{ $relatedService->name }}
                      </a>
                    </h5>
                    <div class="text-muted small">
                      {{ $relatedService->short_desc }}
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="contact-box-custom mt-4 wow fadeInRight" data-wow-delay="0.3s">
            <div class="contact-title p-3 text-main">{{__('website.contact_us')}}</div>
            <x-website.partials.contact-form />
          </div>

        </div>

      </div>
    </div>
  </section>
  <!-- end service details -->
</x-website.layout>