<!--==========================About==========================-->
<section class="why-choose-us-section py-5">
    <div class="container py-5">
        <div class="row justify-content-center align-items-center w-100">
            <div class="col-12 col-md-3 d-flex flex-column align-items-center gap-4 mb-md-0 mb-5">
                <!-- Left Side - First 2 Benefits -->
                @foreach ($benefits->take(2) as $benefit)
                    <div class="whyus-feature text-center mb-2 p-3 shadow-lg rounded-3 border-1">
                        <div class="icon-circle mb-2 d-flex align-items-center justify-content-center">
                            <img src="{{ $benefit->icon_path }}" alt="{{ $benefit->title }}"
                                style="width: 40px; height: 40px; object-fit: contain;">
                        </div>
                        <h6 class="fw-bold mb-1">{{ $benefit->title }}</h6>
                        <p class="text-muted mb-0">{{ $benefit->short_desc }}</p>
                    </div>
                @endforeach
            </div>
            <div class="bg-main rounded-circle d-flex justify-content-center align-items-center mx-3 z-1"
                style="width: 220px; height: 220px;">
                <span class="fw-bold text-white fs-3">{{ __('website.why_us') }}</span>
            </div>
            <div class="col-12 col-md-3 d-flex flex-column align-items-center gap-4 mt-md-0 mt-5">
                <!-- Right Side - Next 2 Benefits -->
                @foreach ($benefits->skip(2)->take(2) as $benefit)
                    <div class="whyus-feature text-center mb-2 p-3 shadow-lg rounded-3 border-1">
                        <div class="icon-circle mb-2 d-flex align-items-center justify-content-center">
                            <img src="{{ $benefit->icon_path }}" alt="{{ $benefit->title }}"
                                style="width: 40px; height: 40px; object-fit: contain;">
                        </div>
                        <h6 class="fw-bold mb-1">{{ $benefit->title }}</h6>
                        <p class="text-muted mb-0">{{ $benefit->short_desc }}</p>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    </div>

</section>

<!--==========================About==========================-->
