<x-dashboard.layout :title="__('dashboard.edit') . $project->name">

    @section('style')
        <style>
            .sortable-container {
                cursor: move;
            }

            .sortable-container.sortable-ghost {
                opacity: 0.5;
            }

            .sortable-container.sortable-chosen {
                background-color: #f8f9fa;
                border: 2px dashed #007bff;
            }

            .drag-handle {
                cursor: move;
                position: absolute;
                top: 5px;
                right: 5px;
                background: rgba(0, 0, 0, 0.5);
                color: white;
                padding: 2px 6px;
                border-radius: 3px;
                font-size: 12px;
            }
        </style>
    @endsection

    <!-- Enhanced Page Header -->
    <div class="enhanced-page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h4>{{ __('dashboard.edit') . $project->name }}</h4>
            </div>
            <div class="col-md-4">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a
                                href="{{ route('dashboard.projects.index') }}">{{ __('dashboard.projects') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('dashboard.edit') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Enhanced Page Header -->

    <!-- Enhanced Form Container -->
    <div class="enhanced-form-container">
        <form action="{{ route('dashboard.projects.update', [$project->id]) }}" method="POST"
            enctype="multipart/form-data">
            @csrf
            @method('PATCH')

            <!-- Basic Information Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-info-circle me-2"></i>{{ __('dashboard.basic_information') }}</h4>

                <div class="row">
                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.name_en') }}</label>
                        <input class="form-control" name="name_en" type="text" value="{{ $project->name_en }}"
                            placeholder="{{ __('dashboard.name_en') }}">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.name_ar') }}</label>
                        <input class="form-control" name="name_ar" type="text" value="{{ $project->name_ar }}"
                            placeholder="{{ __('dashboard.name_ar') }}">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.order') }}</label>
                        <input class="form-control" name="order" type="number" value="{{ $project->order }}"
                            placeholder="{{ __('dashboard.order') }}">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label for="parent">{{ __('dashboard.parent') }}</label>
                        <select class="form-control select2" name="parent_id">
                            <option value="">{{ __('dashboard.no_parent') }}</option>
                            @foreach ($projects as $projectItem)
                                <option value="{{ $projectItem->id }}"
                                    {{ old('parent_id', $project->parent_id) == $projectItem->id ? 'selected' : '' }}>
                                    {{ $projectItem->name }}
                                </option>
                            @endforeach
                        </select>
                        @if ($project->parent)
                            <div class="mt-2 text-info">
                                <small>{{ __('dashboard.current_parent') }}:
                                    <b>{{ $project->parent->name }}</b></small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Images Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-images me-2"></i>{{ __('dashboard.images') }}</h4>

                <div class="row">
                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="image" accept="image/*" id="image-input">
                            <label for="image-input" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                {{ __('dashboard.choose_file') }}
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.image_preview') }}</label>
                        <div class="enhanced-image-preview">
                            @if ($project->image_path && file_exists(public_path($project->image_path)))
                                <img src="{{ asset($project->image_path) }}" alt="{{ $project->name }}">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            @else
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span>{{ __('dashboard.no_image_available') }}</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.alt_image') }}</label>
                        <input class="form-control" name="alt_image" type="text"
                            placeholder="{{ __('dashboard.alt_image') }}" value="{{ $project->alt_image }}">
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="icon" accept="image/*" id="icon-input">
                            <label for="icon-input" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                {{ __('dashboard.choose_file') }}
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.icon_preview') }}</label>
                        <div class="enhanced-image-preview">
                            @if ($project->icon_path && file_exists(public_path($project->icon_path)))
                                <img src="{{ asset($project->icon_path) }}" alt="{{ $project->name }}">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            @else
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span>{{ __('dashboard.no_image_available') }}</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.alt_icon') }}</label>
                        <input class="form-control" name="alt_icon" type="text"
                            placeholder="{{ __('dashboard.alt_icon') }}" value="{{ $project->alt_icon }}">
                    </div>
                </div>
            </div>

            <!-- Descriptions Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-align-left me-2"></i>{{ __('dashboard.descriptions') }}</h4>

                <div class="row">
                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.short_desc_en') }}</label>
                        <textarea class="form-control" name="short_desc_en" placeholder="{{ __('dashboard.short_desc_en') }}">{!! $project->short_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.short_desc_ar') }}</label>
                        <textarea class="form-control" name="short_desc_ar" placeholder="{{ __('dashboard.short_desc_ar') }}">{!! $project->short_desc_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.long_desc_en') }}</label>
                        <textarea class="form-control" id="myeditorinstance" name="long_desc_en"
                            placeholder="{{ __('dashboard.long_desc_en') }}">{!! $project->long_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.long_desc_ar') }}</label>
                        <textarea class="form-control" id="myeditorinstance2" name="long_desc_ar"
                            placeholder="{{ __('dashboard.long_desc_ar') }}">{!! $project->long_desc_ar !!}</textarea>
                    </div>
                </div>
            </div>

            <!-- Project Details Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-project-diagram me-2"></i>{{ __('dashboard.project_details') }}</h4>

                <div class="row">
                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.clients_en') }}</label>
                        <input class="form-control" name="clients_en" type="text"
                            value="{{ $project->clients_en }}" placeholder="{{ __('dashboard.clients_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.location_en') }}</label>
                        <input class="form-control" name="location_en" type="text"
                            value="{{ $project->location_en }}" placeholder="{{ __('dashboard.location_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.category_en') }}</label>
                        <input class="form-control" name="category_en" type="text"
                            value="{{ $project->category_en }}" placeholder="{{ __('dashboard.category_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.service_en') }}</label>
                        <input class="form-control" name="service_en" type="text"
                            value="{{ $project->service_en }}" placeholder="{{ __('dashboard.service_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.clients_ar') }}</label>
                        <input class="form-control" name="clients_ar" type="text"
                            value="{{ $project->clients_ar }}" placeholder="{{ __('dashboard.clients_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.location_ar') }}</label>
                        <input class="form-control" name="location_ar" type="text"
                            value="{{ $project->location_ar }}" placeholder="{{ __('dashboard.location_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.category_ar') }}</label>
                        <input class="form-control" name="category_ar" type="text"
                            value="{{ $project->category_ar }}" placeholder="{{ __('dashboard.category_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.service_ar') }}</label>
                        <input class="form-control" name="service_ar" type="text"
                            value="{{ $project->service_ar }}" placeholder="{{ __('dashboard.service_ar') }}">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.date') }}</label>
                        <input class="form-control" name="date" type="date" value="{{ $project->date }}"
                            placeholder="{{ __('dashboard.date') }}">
                    </div>
                </div>
            </div>

            <!-- Status Controls Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-toggle-on me-2"></i>{{ __('dashboard.status_controls') }}</h4>

                <div class="row">
                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.publish/unpublish') }}</h5>
                            <input type="checkbox" id="switch1" switch="none" value="1" name="status"
                                @checked(old('status', $project->status)) />
                            <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_home') }}</h5>
                            <input type="checkbox" id="switch2" switch="none" value="1" name="show_in_home"
                                @checked(old('show_in_home', $project->show_in_home)) />
                            <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_header') }}</h5>
                            <input type="checkbox" id="switch3" switch="none" value="1"
                                name="show_in_header" @checked(old('show_in_header', $project->show_in_header)) />
                            <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_footer') }}</h5>
                            <input type="checkbox" id="switch4" switch="none" value="1"
                                name="show_in_footer" @checked(old('show_in_footer', $project->show_in_footer)) />
                            <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SEO Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-search me-2"></i>{{ __('dashboard.seo') }}</h4>

                <div class="row">
                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.slug_en') }}</label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="{{ __('dashboard.slug_en') }}" name="slug_en"
                            value="{{ $project->slug_en }}">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_title_en') }}</label>
                        <textarea class="form-control" name="meta_title_en" placeholder="{{ __('dashboard.meta_title_en') }}">{!! $project->meta_title_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_desc_en') }}</label>
                        <textarea class="form-control" name="meta_desc_en" placeholder="{{ __('dashboard.meta_desc_en') }}">{!! $project->meta_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.slug_ar') }}</label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="{{ __('dashboard.slug_ar') }}" name="slug_ar"
                            value="{{ $project->slug_ar }}">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_title_ar') }}</label>
                        <textarea class="form-control" name="meta_title_ar" placeholder="{{ __('dashboard.meta_title_ar') }}">{!! $project->meta_title_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_desc_ar') }}</label>
                        <textarea class="form-control" name="meta_desc_ar" placeholder="{{ __('dashboard.meta_desc_ar') }}">{!! $project->meta_desc_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.meta_robots') }} (index)</h5>
                            <input type="checkbox" id="switch5" switch="none" value="1" name="index"
                                @checked(old('index', $project->index)) />
                            <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Action Buttons -->
            <div class="enhanced-action-buttons text-center">
                <button type="submit" class="btn enhanced-btn enhanced-btn-success">
                    <i class="fas fa-save me-2"></i>{{ __('dashboard.update') }}
                </button>
                <a href="{{ route('dashboard.projects.index') }}" class="btn enhanced-btn enhanced-btn-danger">
                    <i class="fas fa-times me-2"></i>{{ __('dashboard.cancel') }}
                </a>
            </div>
        </form>
    </div>

    @section('script')
        <script>
            var token = "{{ csrf_token() }}";
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enhanced file input preview
            $('#image-input, #icon-input').on('change', function() {
                const file = this.files[0];
                const preview = $(this).closest('.enhanced-form-group').next().find('img');

                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        preview.attr('src', e.target.result);
                        preview.closest('.enhanced-image-preview').find('.enhanced-no-image').hide();
                        preview.show();
                    };
                    reader.readAsDataURL(file);
                }
            });

            // Enhanced form validation
            $('form').on('submit', function(e) {
                let isValid = true;

                $('.enhanced-form-group input[required], .enhanced-form-group textarea[required], .enhanced-form-group select[required]')
                    .each(function() {
                        if (!$(this).val()) {
                            $(this).addClass('is-invalid');
                            isValid = false;
                        } else {
                            $(this).removeClass('is-invalid').addClass('is-valid');
                        }
                    });

                if (!isValid) {
                    e.preventDefault();
                    alert('{{ __('dashboard.please_fill_required_fields') }}');
                }
            });
        </script>
    @endsection

</x-dashboard.layout>
