<?php

namespace Database\Seeders;

use App\Models\Section;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       $data = [
            [
                'key' => 'products',
                'title_en' => 'OUR Products',
                'title_ar' => 'منتجاتنا',
                'second_title_en' => 'Our Products',
                'second_title_ar' => 'منتجاتنا',
                'status' => 1,
            ],
            [
                'key' => 'about',
                'title_en' => 'OUR About',
                'title_ar' => 'عن الشركة',
                'second_title_en' => 'Our About',
                'second_title_ar' => 'عن الشركة',
                'status' => 1,
            ],
            [
                'key' => 'services',
                'title_en' => 'OUR Services',
                'title_ar' => 'خدماتنا',
                'second_title_en' => 'Our Services',
                'second_title_ar' => 'خدماتنا',
                'status' => 1,
            ],[
                'key' => 'projects',
                'title_en' => 'OUR Projects',
                'title_ar' => 'مشاريعنا',
                'second_title_en' => 'Our Projects',
                'second_title_ar' => 'مشاريعنا',
                'status' => 1,
            ],
            [
                'key' => 'contact',
                'title_en' => 'Contact Us',
                'title_ar' => 'تواصل معنا',
                'second_title_en' => 'Contact Us',
                'second_title_ar' => 'تواصل معنا', 
                'status' => 1,
            ],
            
            [
                'key' => 'blogs',
                'title_en' => 'OUR Blogs',
                'title_ar' => 'مدوناتنا',
                'second_title_en' => 'Interesting articles updated daily',
                'second_title_ar' => 'مقالات مثيرة للاهتمام يتم تحديثها يوميًا',
                'status' => 1,
            ],
        ];

        foreach ($data as $item) {
           Section::create($item);
        }
    }
}
