<?php

namespace Database\Seeders;

use App\Models\Dashboard\Menu;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name_en' => 'Home',
                'name_ar' => 'الرئيسية',
                'segment' => '/',
                'parent_id' => null,
                'order' => 1,
                'status' => true,
            ],
            [
                'name_en' => 'About Us',
                'name_ar' => 'من نحن',
                'segment' => '/about-us',
                'parent_id' => null,
                'order' => 2,
                'status' => true,
            ],

            [
                'name_en' => 'Our Services',
                'name_ar' => 'الخدمات',
                'segment' => '/services',
                'parent_id' => null,
                'order' => 3,
                'status' => true,
            ],
            [
                'name_en' => 'Our Products',
                'name_ar' => 'المنتجات',
                'segment' => '/products',
                'parent_id' => null,
                'order' => 4,
                'status' => true,
            ],
            [
                'name_en' => 'Our Projects',
                'name_ar' => 'المشاريع',
                'segment' => '/projects',
                'parent_id' => null,
                'order' => 5,
                'status' => true,
            ],
            [
                'name_en' => 'careers',
                'name_ar' => 'الوظائف',
                'segment' => '/careers',
                'parent_id' => null,
                'order' => 5,
                'status' => true,
            ],
            
            [
                'name_en' => 'News & Articles',
                'name_ar' => 'الأخبار والمقالات',
                'segment' => '/blogs',
                'parent_id' => null,
                'order' => 6,
                'status' => true,
            ],
            [
                'name_en' => 'Contact Us',
                'name_ar' => 'تواصل معنا',
                'segment' => '/contact-us',
                'parent_id' => null,
                'order' => 7,
                'status' => true,
            ],
            // مثال على قائمة رئيسية بدون رابط
            [
                'name_en' => 'Media',
                'name_ar' => 'الميديا',
                'segment' => '#',
                'parent_id' => null,
                'order' => 8,
                'status' => true,
            ]
        ];

        foreach ($data as $item) {
            Menu::updateOrCreate(
                ['segment' => $item['segment']],
                $item
            );
        }

        // إضافة القوائم الفرعية لقائمة "الميديا"
        $mediaMenu = Menu::where('segment', '#')->where('name_en', 'Media')->first();
        
        if ($mediaMenu) {
            $subMenus = [
                [
                    'name_en' => 'Photo Gallery',
                    'name_ar' => 'جاليري الصور',
                    'segment' => '/gallery-photos',
                    'parent_id' => $mediaMenu->id,
                    'order' => 1,
                    'status' => true,
                ],
                [
                    'name_en' => 'Video Gallery',
                    'name_ar' => 'جاليري الفيديو',
                    'segment' => '/gallery-videos',
                    'parent_id' => $mediaMenu->id,
                    'order' => 2,
                    'status' => true,
                ]
            ];

            foreach ($subMenus as $subMenu) {
                Menu::updateOrCreate(
                    ['segment' => $subMenu['segment']],
                    $subMenu
                );
            }
        }
    }
}