<?php

namespace App\Services\Dashboard;

use App\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PageService
{
    /**
     * Clean Arabic text for slug usage
     * Keep Arabic characters but remove special characters and spaces
     */
    private function cleanArabicSlug($text)
    {
        // Replace spaces and special characters with dashes, but keep Arabic characters
        $slug = str_replace([' ', '/', '\\', '?', '#', '[', ']', '@', '!', '$', '&', "'", '(', ')', '*', '+', ',', ';', '=', '%'], '-', $text);

        // Remove multiple dashes
        $slug = preg_replace('/-+/', '-', $slug);

        // Remove leading/trailing dashes
        $slug = trim($slug, '-');

        return $slug;
    }

    public function store($data)
    {
        DB::beginTransaction();
        try {
            $data['slug_en'] = Str::slug($data['title_en']);
            $data['slug_ar'] = $this->cleanArabicSlug($data['title_ar']);

            Page::create($data);

            DB::commit();

            return true;
        } catch (\Exception $e) {

            DB::rollBack();

            throw $e;
        }
    }

    public function update($data, $page)
    {

        DB::beginTransaction();
        try {
            $data['status'] = $data['status'] ?? 0;
            $data['slug_en'] = Str::slug($data['slug_en']);
            $data['slug_ar'] = $this->cleanArabicSlug($data['slug_ar']);

            $page->update($data);

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds)
    {

        DB::beginTransaction();

        try {

            $deleted = Page::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return $deleted > 0;
        } catch (\Exception $e) {
            DB::rollBack();

            throw $e;
        }
    }
}
