<?php

namespace App\Services\Dashboard;

use App\Models\Dashboard\Menu;
use Illuminate\Support\Facades\Cache;

class MenuService
{
    public function store($data)
    {
        $menu = Menu::create($data);
        $this->clearMenuCache();
        return $menu;
    }

    public function update($data, $menu)
    {
        $data['status'] = $data['status'] ?? 0;
        $menu->update($data);
        $this->clearMenuCache();
        return $menu;
    }

    public function delete($selectedIds)
    {
        try {
            $result = Menu::whereIn('id', $selectedIds)->delete();
            $this->clearMenuCache();
            return $result;
        } catch (\Exception $e) {
            throw $e;
        }
    }

    /**
     * Clear all menu-related cache
     */
    private function clearMenuCache()
    {
        Cache::forget('website_menus');
        Cache::forget('hierarchical_menus');
        Cache::forget('footer_menus');
    }
}
