<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\Website\SaveCareerApplicationRequest;
use App\Http\Requests\Website\StoreContactUsRequest;
use App\Models\Benefit;
use App\Models\Blog;
use App\Models\Dashboard\AboutStruct;
use App\Models\Dashboard\AboutUs;
use App\Models\Dashboard\Domain;
use App\Models\Faq;
use App\Models\GalleryVideo;
use App\Models\JobPosition;
use App\Models\Product;
use App\Models\Project;
use App\Models\Service;
use App\Models\SiteAddress;
use App\Models\Statistic;
use App\Services\Dashboard\SaveApplicationService;
use App\Services\Website\ContactUsService;
use App\Services\Website\StoreContactUsService;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Section;
use App\Models\Album;

class WebsiteController extends Controller
{
    public function about()
    {
        $data['about'] = AboutUs::first();
        $data['about_structs'] = AboutStruct::active()->get();
        $data['faqs'] = Faq::active()->general()->get();
        $data['statistics'] = Statistic::active()->take(4)->get();
        return view('Website.about', $data);
    }

    public function services()
    {
        // Get all services except children (services without parent_id)
        $data['services'] = Service::active()->whereNull('parent_id')->get();
        $data['sections'] = Section::all();

        return view('Website.services', $data);
    }

    public function serviceDetails($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $service = Service::where($column, $slug)->first();
        $service->{'long_desc_' . $locale} = str_replace('#call#', view('Website.partials._call-buttons')->render(), $service->{'long_desc_' . $locale});
        return view('Website.service-details', compact('service'));
    }

    public function subService($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $parentService = Service::where($column, $slug)->with('children')->first();

        if (!$parentService) {
            abort(404);
        }

        $data['parentService'] = $parentService;
        $data['subServices'] = $parentService->children;
        $data['sections'] = Section::all();

        return view('Website.sub-service', $data);
    }

    public function categories()
    {
        $data['categories'] = Category::active()->get();
        $data['services'] = Service::active()->get();
        return view('Website.categories', $data);
    }

    public function categoryDetails($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $category = Category::where($column, $slug)->first();
        $category->{'long_desc_' . $locale} = str_replace('#call#', view('Website.partials._call-buttons')->render(), $category->{'long_desc_' . $locale});
        return view('Website.category-details', compact('category'));
    }

    public function showContactUs()
    {
        $data['site_addresses'] = SiteAddress::active()->orderBy('order')->get();
        return view('Website.contact-us', $data);
    }

    public function saveContactUs(StoreContactUsRequest $request)
    {
        try {

            $data = $request->validated();

            $response = (new ContactUsService)->store($data);

            if (!$response) {
                return redirect()->back()->with(['error' => __('website.failed_to_send_message')]);
            }

            return redirect()->back()->with(['success' => __('website.thanks_message')]);
        } catch (\Exception $e) {

            return redirect()->back()->with(['error' => __('website.something wrong pls try letter')]);
        }
    }

    public function products()
    {
        $data['products'] = Product::active()->get();

        return view('Website.products', $data);
    }
    public function productDetails($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $product = Product::where($column, $slug)->first();
        $product->{'long_desc_' . $locale} = str_replace('#call#', view('Website.partials._call-buttons')->render(), $product->{'long_desc_' . $locale});
        return view('Website.product-details', compact('product'));
    }

    public function projects()
    {
        $data['projects'] = Project::active()->get();
        return view('Website.projects', $data);
    }
    public function projectDetails($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $project = Project::where($column, $slug)->first();
        $project->{'long_desc_' . $locale} = str_replace('#call#', view('Website.partials._call-buttons')->render(), $project->{'long_desc_' . $locale});
        return view('Website.project-details', compact('project'));
    }

    public function blogs()
    {
        $data['blogs'] = Blog::active()->get();
        $data['sections'] = \App\Models\Section::all();
        return view('Website.blogs', $data);
    }
    public function blogDetails($slug)
    {
        $locale = app()->getLocale();
        $column = $locale == 'ar' ? 'slug_ar' : 'slug_en';
        $blog = Blog::where($column, $slug)->first();
        $blog->{'long_desc_' . $locale} = str_replace('#call#', view('Website.partials._call-buttons')->render(), $blog->{'long_desc_' . $locale});
        return view('Website.blog-details', compact('blog'));
    }

    public function careers()
    {
        $data['gallery_videos'] = GalleryVideo::active()->get();
        $data['job_positions'] = JobPosition::active()->get();
        return view('Website.careers', $data);
    }

    public function saveApplication(SaveCareerApplicationRequest $request)
    {
        try {

            $response = (new SaveApplicationService)->saveApplication($request);

            if (!$response) {
                return redirect()->back()->with(['error' => __('website.failed_to_send_message')]);
            }

            return redirect()->back()->with(['success' => __('website.thanks_message')]);
        } catch (\Exception $e) {

            return redirect()->back()->with(['error' => __('website.something wrong pls try letter')]);
        }
    }

    public function galleryPhotos()
    {
        $data['gallery_photos'] = Album::active()->get();
        return view('Website.gallery-photos', $data);
    }

    public function galleryVideos()
    {
        $data['gallery_videos'] = GalleryVideo::active()->get();
        return view('Website.gallery-videos', $data);
    }
}
