<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Dashboard\AboutUs;
use App\Models\Dashboard\AboutStruct;
use App\Models\Section;
use App\Models\Service;
use App\Models\Phone;
use App\Models\SiteAddress;
use App\Models\Setting;

class AMPController extends Controller
{
    /**
     * Display the AMP home page
     */
    public function home()
    {
        // Disable debugbar for AMP pages
        if (class_exists('\Barryvdh\Debugbar\Facades\Debugbar')) {
            \Barryvdh\Debugbar\Facades\Debugbar::disable();
        }

        $services = Service::active()->take(6)->get();
        $phones = Phone::active()->get();
        $site_addresses = SiteAddress::active()->orderBy('order')->get();

        // Get settings
        $site_name = Setting::where('key', 'site_name')->first()->value ?? 'Tulip';
        $site_description = Setting::where('key', 'site_description')->first()->value ?? 'Professional Web Services & Digital Solutions';
        $socialMediaLinks = SocialMedia::active()->get();
        $settings = (object) [
            'site_name' => $site_name,
            'site_description' => $site_description
        ];

        return view('amp.home', compact('services', 'phones', 'site_addresses', 'settings'));
    }

    /**
     * Display the AMP about page
     */
    public function about()
    {
        // Disable debugbar for AMP pages
        if (class_exists('\Barryvdh\Debugbar\Facades\Debugbar')) {
            \Barryvdh\Debugbar\Facades\Debugbar::disable();
        }

        // Get about data from database or use fallback
        $aboutData = AboutUs::first();

        if ($aboutData) {
            $about = (object) [
                'title' => '🌷 ' . $aboutData->title,
                'title2' => $aboutData->sub_title ?? 'Our Mission',
                'title3' => 'Why Choose Us?',
                'description' => $aboutData->short_desc ?? 'Learn about our mission and values.',
                'text' => $aboutData->text ?? 'We are dedicated to helping businesses achieve their digital goals.'
            ];
        } else {
            // Fallback data if no database records
            $about = (object) [
                'title' => '🌷 About Tulip',
                'title2' => 'Our Mission',
                'title3' => 'Why Choose Us?',
                'description' => 'Learn about our mission and values.',
                'text' => 'We are dedicated to helping businesses achieve their digital goals.'
            ];
        }

        // Get about structure sections
        $aboutSections = AboutStruct::active()->orderBy('order')->get();
        $about_structs = $aboutSections; // For compatibility with the view

        // Get sections for banner
        $sections = Section::all();

        return view('amp.about', compact('about', 'aboutSections', 'about_structs', 'sections'));
    }

    /**
     * Display the AMP services page
     */
    public function services()
    {
        // Disable debugbar for AMP pages
        if (class_exists('\Barryvdh\Debugbar\Facades\Debugbar')) {
            \Barryvdh\Debugbar\Facades\Debugbar::disable();
        }

        return view('amp.services');
    }

    /**
     * Display the AMP contact page
     */
    public function contact()
    {
        // Disable debugbar for AMP pages
        if (class_exists('\Barryvdh\Debugbar\Facades\Debugbar')) {
            \Barryvdh\Debugbar\Facades\Debugbar::disable();
        }

        return view('amp.contact');
    }
}