# Service Worker Documentation

## Overview
This Service Worker provides offline functionality for the Tulip website with intelligent error handling and caching strategies.

## Features
- **Offline Page Support**: Shows cached pages when offline
- **Smart Error Handling**: Distinguishes between server errors and network failures
- **Development-Friendly**: Shows Laravel errors in development, beautiful error pages in production
- **Cache Management**: Automatic caching with periodic refresh

## Files
- `public/sw.js` - Main Service Worker file
- `public/offline-simple.html` - Offline page with contact information
- `public/manifest.json` - PWA manifest
- `resources/views/errors/500.blade.php` - Beautiful 500 error page
- `resources/views/errors/404.blade.php` - Beautiful 404 error page

## How It Works

### Development Mode
- Shows detailed console logs
- Displays Laravel error pages with stack traces
- Error routes available for testing

### Production Mode
- Minimal console logging
- Beautiful error pages for users
- Optimized performance

## Error Handling Strategy
1. **Server Errors (5xx)**: Show actual Laravel error page
2. **404 Errors**: Try cache first, then show 404 page
3. **Network Failures**: Show cached pages or offline page
4. **Other Errors**: Show appropriate error pages

## Cache Strategy
- **Pages**: Network First (fresh content preferred)
- **Resources**: Cache First (performance optimized)
- **Offline**: Serve cached pages when network fails

## Maintenance
- Cache version: Update `CACHE_NAME` in `sw.js` to force updates
- Offline page: Edit `public/offline-simple.html`
- Error pages: Edit files in `resources/views/errors/`

## Environment Detection
The Service Worker automatically detects development vs production environment based on hostname:
- Development: `localhost`, `.test`, `127.0.0.1`
- Production: All other domains

## Testing
- Visit any page to cache it
- Disable network to test offline functionality
- Trigger server errors to test error handling
- Check browser DevTools > Application > Service Workers
