# PWA Manifest System - نظام PWA الديناميكي

## نظرة عامة / Overview

تم إنشاء نظام PWA Manifest ديناميكي يأخذ البيانات من قاعدة البيانات بدلاً من ملف ثابت. هذا يسمح بإدارة إعدادات PWA من لوحة التحكم.

A dynamic PWA Manifest system has been created that pulls data from the database instead of a static file. This allows managing PWA settings from the dashboard.

## الميزات / Features

### ✅ **إدارة ديناميكية للإعدادات**
- **اسم الموقع** - يأخذ من `site_name` في قاعدة البيانات
- **الاسم المختصر** - يأخذ من `site_short_name` 
- **الوصف** - يأخذ من `site_description`
- **الألوان** - `theme_color` و `background_color`
- **الشعار** - `site_logo` مع معالجة تلقائية للأحجام المختلفة

### ✅ **دعم متعدد اللغات**
- **العربية** - `dir: rtl`, `lang: ar`
- **الإنجليزية** - `dir: ltr`, `lang: en`
- **اختصارات ديناميكية** حسب اللغة

### ✅ **أيقونات ذكية**
- **شعار مخصص** - إذا تم رفع شعار، يتم إنشاء أحجام مختلفة تلقائياً
- **أيقونات افتراضية** - إذا لم يتم رفع شعار، يستخدم الأيقونات الافتراضية

## الملفات المضافة / Added Files

### 1. **Controller**
```
app/Http/Controllers/ManifestController.php
```
- `manifest()` - دالة إنشاء manifest.json ديناميكي
- `generateShortcuts()` - إنشاء اختصارات حسب اللغة
- `generateIcons()` - إنشاء أيقونات ذكية

### 2. **Route**
```php
// routes/web.php
Route::get('/manifest.json', [ManifestController::class, 'manifest'])->name('manifest');
```

### 3. **Migration**
```
database/migrations/2025_09_14_220304_add_manifest_settings_to_settings_table.php
```
إضافة الإعدادات التالية:
- `site_short_name`
- `site_description`
- `theme_color`
- `background_color`
- `site_logo`

### 4. **Dashboard Interface**
- **صفحة الإعدادات** - قسم جديد لإدارة PWA
- **ترجمات** - عربي وإنجليزي
- **Validation** - قواعد التحقق من صحة البيانات

## كيفية الاستخدام / How to Use

### 1. **إدارة الإعدادات**
1. اذهب إلى **لوحة التحكم** → **الإعدادات**
2. ابحث عن قسم **"إعدادات PWA Manifest"**
3. املأ الحقول المطلوبة:
   - **الاسم المختصر**: `Tulip`
   - **الوصف**: `خدمات تطوير ويب احترافية`
   - **لون المظهر**: `#007bff`
   - **لون الخلفية**: `#ffffff`
   - **الشعار**: ارفع صورة (512x512 بكسل)

### 2. **الوصول للـ Manifest**
```
https://yoursite.com/manifest.json
https://yoursite.com/ar/manifest.json
https://yoursite.com/en/manifest.json
```

### 3. **مثال على النتيجة**
```json
{
  "name": "موقعي",
  "short_name": "Tulip",
  "description": "هذا هو وصف موقعي.",
  "start_url": "/ar",
  "display": "standalone",
  "background_color": "#ffffff",
  "theme_color": "#007bff",
  "orientation": "portrait-primary",
  "icons": [...],
  "lang": "ar",
  "dir": "rtl",
  "shortcuts": [...]
}
```

## الإعدادات المتاحة / Available Settings

| الإعداد / Setting | المفتاح / Key | النوع / Type | الوصف / Description |
|------------------|---------------|--------------|-------------------|
| الاسم المختصر | `site_short_name` | string | اسم قصير يظهر في شاشة البداية |
| وصف الموقع | `site_description` | string | وصف الموقع في متجر التطبيقات |
| لون المظهر | `theme_color` | color | اللون الرئيسي في شريط الحالة |
| لون الخلفية | `background_color` | color | لون الخلفية عند التحميل |
| شعار الموقع | `site_logo` | image | شعار الموقع (512x512 بكسل) |

## الاختصارات الديناميكية / Dynamic Shortcuts

### العربية
- **الصفحة الرئيسية** - `/ar`
- **الخدمات** - `/ar/services`
- **المنتجات** - `/ar/products`
- **اتصل بنا** - `/ar/contact`

### الإنجليزية
- **Home** - `/en`
- **Services** - `/en/services`
- **Products** - `/en/products`
- **Contact Us** - `/en/contact`

## معالجة الأيقونات / Icon Handling

### شعار مخصص
إذا تم رفع شعار، يتم إنشاء أحجام مختلفة:
- **152x152** - أيقونة صغيرة
- **192x192** - أيقونة متوسطة
- **512x512** - أيقونة كبيرة

### أيقونات افتراضية
إذا لم يتم رفع شعار، يستخدم:
- `icon-152x152.svg`
- `icon-192x192.svg`
- `icon-512x512.svg`

## التخزين المؤقت / Caching

- **Cache Headers**: `Cache-Control: public, max-age=3600`
- **مدة التخزين**: ساعة واحدة
- **إعادة التحميل**: عند تحديث الإعدادات

## الأمان / Security

- **Validation**: تحقق من صحة البيانات المدخلة
- **File Upload**: تحقق من نوع وحجم الملفات
- **Authorization**: صلاحيات إدارة الإعدادات

## استكشاف الأخطاء / Troubleshooting

### المشاكل الشائعة

1. **Manifest لا يظهر**
   - تأكد من أن الرابط صحيح: `/manifest.json`
   - امسح الكاش: `php artisan cache:clear`

2. **الشعار لا يظهر**
   - تأكد من رفع الصورة في الإعدادات
   - تحقق من صلاحيات مجلد `storage/settings`

3. **الألوان لا تتغير**
   - امسح كاش المتصفح
   - تأكد من حفظ الإعدادات

## التطوير المستقبلي / Future Development

- [ ] **إدارة الشاشات** - إضافة screenshots
- [ ] **إعدادات متقدمة** - categories مخصصة
- [ ] **تحليلات PWA** - تتبع استخدام التطبيق
- [ ] **إشعارات** - push notifications

---

## الدعم / Support

إذا واجهت أي مشاكل، يرجى:
1. التحقق من logs: `storage/logs/laravel.log`
2. التأكد من صلاحيات الملفات
3. مسح الكاش: `php artisan cache:clear`

---

**تم إنشاؤه بواسطة / Created by**: Mepicom Development Team  
**التاريخ / Date**: 2025-09-14  
**الإصدار / Version**: 1.0.0
