<script>
   



    $(document).ready(function() {
        if (typeof $ === 'undefined') {
            console.error('jQuery is not loaded!');
            return;
        }

        if ($('#btn_delete').length === 0) {
            console.error('Delete button not found!');
            return;
        }

        $('#btn_delete').on('click', function(e) {
            e.preventDefault();

            var selectedCheckboxes = $(".check-inputs:checked");
            var selectedIds = [];

            selectedCheckboxes.each(function() {
                selectedIds.push($(this).val());
            });

            if (selectedIds.length === 0) {
                Swal.fire({
                    title: "<?php echo e(__('messages.no_select')); ?>",
                    text: "<?php echo e(__('messages.please select at least one')); ?>",
                    icon: "warning",
                    confirmButtonColor: "#5156be"
                });
                return;
            }

            Swal.fire({
                title: "<?php echo e(__('messages.are you sure')); ?>",
                text: "<?php echo e(__('messages.remove checked values')); ?>",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "<?php echo e(__('messages.yes, delete it')); ?>!"
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    // For bulk delete, use the bulk delete route
                    var deleteUrl = selectedIds.length === 1 ? url + '/' + selectedIds[0] :
                        url + '/bulk';

                    $.ajax({
                        url: deleteUrl,
                        type: 'DELETE',
                        data: {
                            selectedIds: selectedIds
                        },
                        beforeSend: function() {
                            Swal.fire({
                                title: "<?php echo e(__('messages.deleting')); ?>",
                                text: "<?php echo e(__('messages.please_wait')); ?>",
                                allowOutsideClick: false,
                                allowEscapeKey: false,
                                showConfirmButton: false,
                                didOpen: () => {
                                    Swal.showLoading();
                                }
                            });
                        },
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: "success",
                                    title: "<?php echo e(__('messages.deleted')); ?>",
                                    text: response.message,
                                    showConfirmButton: false,
                                    timer: 1500
                                });

                                $(document).trigger('recordDeleted');

                                setTimeout(function() {
                                    location.reload();
                                }, 1500);
                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "<?php echo e(__('messages.error')); ?>",
                                    text: response.message ||
                                        "<?php echo e(__('messages.an_error_occurred')); ?>"
                                });
                            }
                        },
                        error: function(xhr) {
                            var message = xhr.responseJSON?.message ||
                                "<?php echo e(__('messages.an_error_occurred')); ?>";
                            Swal.fire({
                                icon: "error",
                                title: "<?php echo e(__('messages.error')); ?>",
                                text: message
                            });
                        }
                    });
                }
            });
        });
    });
</script>
<?php /**PATH /home/yzr9cw1vk5k5/public_html/api_three_cuts/resources/views/components/dashboard/partials/delete-btn.blade.php ENDPATH**/ ?>