<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name',
    'type' => 'text',
    'required' => false,
    'model' => null,
    'placeholder' => null,
    'class' => 'form-control',
    'rows' => null,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name',
    'type' => 'text',
    'required' => false,
    'model' => null,
    'placeholder' => null,
    'class' => 'form-control',
    'rows' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    // Get languages that should be shown in forms
    $formLanguages = config('app.form_languages', ['en', 'ar', 'fr']);

    // Get language data for form languages only
    $allLanguages = config('laravellocalization.supportedLocales');
    $supportedLanguages = array_intersect_key($allLanguages, array_flip($formLanguages));

    // Define language display names
    $languageNames = [
        'en' => 'English',
        'ar' => 'العربية',
        'fr' => 'Français',
        'de' => 'Deutsch',
    ];
?>

<div class="row">
    <?php $__currentLoopData = $supportedLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langCode => $langData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-md-<?php echo e(count($supportedLanguages) > 2 ? '4' : '6'); ?>">
            <label class="">
                <?php echo e(__('dashboard.' . $name . '_' . $langCode)); ?>

                <?php if($required && $langCode === 'en'): ?>
                    <span class="text-danger">*</span>
                <?php endif; ?>
            </label>

            <?php if($type === 'textarea'): ?>
                <textarea class="<?php echo e($class); ?>" name="<?php echo e($name); ?>_<?php echo e($langCode); ?>"
                    <?php if($rows): ?> rows="<?php echo e($rows); ?>" <?php endif; ?>
                    placeholder="<?php echo e($placeholder ?? __('dashboard.' . $name . '_' . $langCode)); ?>"
                    <?php if($required && $langCode === 'en'): ?> required <?php endif; ?>><?php echo e(old($name . '_' . $langCode, $model ? $model->getTranslation($name, $langCode) : '')); ?></textarea>
            <?php elseif($type === 'editor'): ?>
                <textarea class="<?php echo e($class); ?>" name="<?php echo e($name); ?>_<?php echo e($langCode); ?>"
                    id="<?php echo e($name); ?>_<?php echo e($langCode); ?>_editor" rows="<?php echo e($rows ?? 10); ?>"
                    placeholder="<?php echo e($placeholder ?? __('dashboard.' . $name . '_' . $langCode)); ?>"><?php echo e(old($name . '_' . $langCode, $model ? $model->getTranslation($name, $langCode) : '')); ?></textarea>
            <?php else: ?>
                <input class="<?php echo e($class); ?>" name="<?php echo e($name); ?>_<?php echo e($langCode); ?>"
                    type="<?php echo e($type); ?>"
                    value="<?php echo e(old($name . '_' . $langCode, $model ? $model->getTranslation($name, $langCode) : '')); ?>"
                    placeholder="<?php echo e($placeholder ?? __('dashboard.' . $name . '_' . $langCode)); ?>"
                    <?php if($required && $langCode === 'en'): ?> required <?php endif; ?>>
            <?php endif; ?>

            <small class="text-muted"><?php echo e($languageNames[$langCode] ?? $langData['native']); ?></small>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php /**PATH /home/yzr9cw1vk5k5/public_html/api_three_cuts/resources/views/components/dashboard/multilingual-input.blade.php ENDPATH**/ ?>