<?php

use App\Http\Controllers\Website\HomeController;
use App\Http\Controllers\Website\WebsiteController;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

// All routes will be automatically prefixed with the current locale by LaravelLocalization
Route::group(['prefix' => LaravelLocalization::setLocale(), 'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath', 'redirects', 'lang.redirect', 'secure.headers']], function () {
    Route::get('/', HomeController::class)->name('home');
    Route::get('/manifest.json', [\App\Http\Controllers\ManifestController::class, 'manifest'])->name('manifest');
    Route::get('about-us', [WebsiteController::class, 'about'])->name('about-us');
    Route::get('services', [WebsiteController::class, 'services'])->name('services');
    Route::get('services/{slug}', [WebsiteController::class, 'serviceDetails'])->name('serviceDetails');
    Route::get('contact-us', [WebsiteController::class, 'showContactUs'])->name('contact-us');
    Route::post('save-contact-us', [WebsiteController::class, 'saveContactUs'])->name('saveConatct')->middleware('throttle:2');
    Route::get('faqs', [WebsiteController::class, 'faqs'])->name('faqs');
    Route::get('products', [WebsiteController::class, 'products'])->name('products');
    Route::get('suppliers', [WebsiteController::class, 'suppliers'])->name('suppliers');

    Route::get('projects', [WebsiteController::class, 'projects'])->name('projects');
    Route::get('projects/{project}', [WebsiteController::class, 'projectDetails'])->name('projectDetails');
    Route::get('products/{product}', [WebsiteController::class, 'productDetails'])->name('productDetails');
    Route::get('categories', [WebsiteController::class, 'categories'])->name('categories');
    Route::get('categories/{slug}', [WebsiteController::class, 'categoryDetails'])->name('categoryDetails');
    Route::get('blogs', [WebsiteController::class, 'blogs'])->name('blogs');
    Route::get('blogs/{slug}', [WebsiteController::class, 'blogDetails'])->name('blogDetails');
    Route::get('careers', [WebsiteController::class, 'careers'])->name('careers');
    Route::post('save-application', [WebsiteController::class, 'saveApplication'])->name('saveApplication');
    Route::get('gallery-photos', [WebsiteController::class, 'galleryPhotos'])->name('galleryPhotos');
    Route::get('gallery-videos', [WebsiteController::class, 'galleryVideos'])->name('galleryVideos');
});
