
       @php
        $supportedLocales = config('laravellocalization.supportedLocales', []);
        $currentLocale = app()->getLocale();

        $flags = [
            'en' => '🇺🇸',
            'ar' => '🇸🇦',
            'fr' => '🇫🇷',
            'de' => '🇩🇪',
            'es' => '🇪🇸',
            'it' => '🇮🇹',
            'pt' => '🇵🇹',
            'ru' => '🇷🇺',
            'zh' => '🇨🇳',
            'ja' => '🇯🇵',
            'ko' => '🇰🇷',
            'tr' => '🇹🇷',
        ];
    @endphp
   <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav ms-auto d-flex align-items-center gap-3">
            @if (isset($menus) && count($menus) > 0)
                @foreach ($menus as $menu)
                    @if ($menu->segment == '/products')
                    
                        <li class="nav-item dropdown">
                            <a
                            class="nav-link"
                            href="#"
                            id="galleryDropdown"
                            role="button"
                            data-bs-toggle="dropdown"
                            aria-expanded="false"
                            >
                            {{ $menu->name  }} <i class="fas fa-chevron-down"></i>
                            </a>
                        
                            <ul class="dropdown-menu shadow-lg border-0 rounded-3">
                                @foreach ($headerProducts as $headerProduct)
                                    <li>
                                        <a class="dropdown-item d-flex align-items-center gap-2 fs-6" href="{{$headerProduct->link}}">
                                            {{$headerProduct->name}}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                    @else
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is(ltrim($menu->link, '/')) ? 'active' : '' }}" href="{{$menu->link}}">{{$menu->name}}</a>
                    </li>
                    @endif
                @endforeach
            @endif
        </ul>

        <ul class="navbar-nav d-flex align-items-center gap-2 ms-2">
          <li>
            <!-- زر للداكن/الفاتح -->
            <button
              class="themeToggle btn btn-send px-3 rounded-circle d-flex justify-content-center align-items-center"
              style="width: 45px; height: 45px"
            >
              <i class="themeIcon fa-solid fa-sun"></i>
            </button>
          </li>
          <li>
              @foreach ($supportedLocales as $code => $language)
                @if ($code !== $currentLocale)
                    <a href="{{ \App\Helpers\LocalizationHelper::getCurrentPageLocalizedUrl($code) }}" class="btn btn-send"> {{ $flags[$code] ?? '🌐' }} {{ $language['native'] }}</a>
                @endif
            @endforeach
          </li>
        </ul>
      </div>