@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form class="needs-validation wow fadeInUp"  data-wow-delay="1s" action="{{ Path::AppUrl('save-contact-us') }}" method="post">
    @csrf
            <div class="row g-4">
              <div class="col-md-12">
                <input type="text" class="form-control" name="name" placeholder="{{ __('website.name') }}" required>
              </div>
              <div class="col-md-12">
                <input type="email" class="form-control" name="email" placeholder="{{ __('website.email') }}" required>
              </div>
              <div class="col-md-12">
                <input type="text" class="form-control"  name="phone" placeholder="{{ __('website.phone') }}" required>
              </div>
              <div class="col-md-12">
                <select class="form-select" name="product_id" required>
                  <option selected disabled>@lang('website.products')</option>
                  @foreach ($products as $product)
                      <option value="{{ $product->id }}">{{ $product->name }}</option>
                      
                  @endforeach
                 
                </select>
              </div>
              <div class="col-md-12">
                <textarea  class="form-control" name="message" id="" cols="60" rows="5" placeholder="{{ __('website.message') }}" required></textarea>
              </div>
            </div>
         <input type="hidden" name="recaptcha_token" id="recaptcha_token">

            <div class="mt-4">
              <button type="submit" class="btn btn-send w-100 wow pulse" >
                <i class="fa fa-paper-plane me-2"></i> @lang('website.send')
              </button>
            </div>
          </form>


<!-- <======================= EndContactForm =========================> -->
@if (config('captcha.sitekey') && config('captcha.sitekey') !== 'Key')
    <script src="https://www.google.com/recaptcha/api.js?render={{ config('captcha.sitekey') }}"></script>

    <script>
        grecaptcha.ready(function() {
            grecaptcha.execute('{{ config('captcha.sitekey') }}', {
                action: 'contact'
            }).then(function(token) {
                document.getElementById('recaptcha_token').value = token;
            }).catch(function(error) {
                console.warn('reCAPTCHA error:', error);
            });
        });
    </script>
@else
    <script>
        console.warn('reCAPTCHA is not configured properly. Please set NOCAPTCHA_SITEKEY in your .env file');
    </script>
@endif
