    <!--<< Main.js >>-->

    <!-- js -->
    <script src="{{ Path::js('bootstrap.bundle.min.js') }}"></script>
    <script src="{{ Path::js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ Path::js('owl.carousel.min.js') }}"></script>
    <script src="{{ Path::js('wow.min.js') }}"></script>
    <script src="{{ Path::js('main.js') }}"></script>
    <script>
      new WOW().init();
    </script>
    <!-- main-js -->
<script src="{{ asset('js/sw-updater.js') }}"></script>



    <script>
        let recaptchaLoaded = false;

        function loadRecaptcha() {
            if (recaptchaLoaded) return;
            recaptchaLoaded = true;

            const script = document.createElement('script');
            script.src = "https://www.google.com/recaptcha/api.js?onload=onRecaptchaLoadCallback&render=explicit";
            script.async = true;
            script.defer = true;
            document.body.appendChild(script);
        }

        function onRecaptchaLoadCallback() {
            grecaptcha.render(document.querySelector('.g-recaptcha'), {
                'sitekey': "{{ config('captcha.sitekey') }}"
            });
        }

        document.addEventListener("DOMContentLoaded", function() {
            const form = document.querySelector(".contact-form");
            if (form) {
                form.addEventListener("focusin", loadRecaptcha, {
                    once: true
                });
            }
        });
    </script>

    {{-- PWA Service Worker Registration --}}
    <script>
        // PWA Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('{{ asset('sw.js') }}').then(function(registration) {
                    console.log('✅ PWA: Service Worker registered successfully');

                    // Check for updates
                    registration.addEventListener('updatefound', () => {
                        const newWorker = registration.installing;
                        if (newWorker) {
                            newWorker.addEventListener('statechange', () => {
                                if (newWorker.state === 'installed' && navigator
                                    .serviceWorker.controller) {
                                    console.log('🔄 PWA: New version available');
                                    // You can show a notification here
                                }
                            });
                        }
                    });
                }).catch(function(error) {
                    console.log('❌ PWA: Service Worker registration failed:', error);
                });
            });
        }

        // PWA Install Prompt Handler - Completely Disabled
        // No install button or prompts will be shown

        // PWA functionality disabled - no install prompts
    </script>
