
@if (!empty($metatags))
    {{-- Basic Meta Tags --}}
    <meta charset="{{ $metatags['charset'] ?? 'utf-8' }}">
    <meta name="viewport" content="{{ $metatags['viewport'] ?? 'width=device-width, initial-scale=1.0' }}">
    <meta http-equiv="Content-Language" content="{{ $metatags['language'] ?? 'en' }}">
    <meta name="robots" content="{{ $metatags['robots'] ?? 'index, follow' }}">
    <meta name="description" content="{{ $metatags['description'] ?? '' }}">
    @if (!empty($metatags['keywords']))
        <meta name="keywords" content="{{ $metatags['keywords'] }}">
    @endif
    <meta name="author" content="{{ $metatags['author'] ?? '' }}">
    <title>{{ $metatags['title'] ?? config('settings.site_name') }}</title>

    @if (!empty($metatags['time']))
        <meta name="time" content="{{ $metatags['time'] }}">
    @endif

    {{-- Security Headers --}}
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    {{-- <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"> --}}
    <meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">

    {{-- Canonical --}}
    @if (!empty($metatags['canonical']))
        <link rel="canonical" href="{{ $metatags['canonical'] }}">
    @else
        {{-- Generate clean canonical URL without language prefix conflicts --}}
        @php
            $currentUrl = url()->current();
            $canonicalUrl = $currentUrl;

            // Remove language prefix if it exists and we're on a localized route
            if (app()->getLocale() !== config('app.fallback_locale')) {
                $localePrefix = '/' . app()->getLocale();
                if (str_starts_with($currentUrl, $localePrefix)) {
                    $canonicalUrl = str_replace($localePrefix, '', $currentUrl);
                }
            }

            // Ensure we have a clean base URL
            $canonicalUrl = rtrim($canonicalUrl, '/');
            if (empty($canonicalUrl)) {
                $canonicalUrl = url('/');
            }
            @endphp
                <link rel="canonical" href="{{ $canonicalUrl }}">
            @endif

    {{-- Favicon --}}
    <link rel="icon" href="{{ \App\Helper\Path::FavIcon() }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('favicon.png') }}" type="image/png">
    <link rel="apple-touch-icon" href="{{ asset('favicon.png') }}">

    {{-- PWA Manifest --}}
    <link rel="manifest" href="{{ url(app()->getLocale() . '/manifest.json') }}">

    {{-- PWA Meta Tags --}}
    <meta name="theme-color" content="#007bff">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="{{ $metatags['title'] ?? config('settings.site_name') }}">
    <meta name="msapplication-TileColor" content="#007bff">
    <meta name="msapplication-tap-highlight" content="no">

    {{-- Apple Touch Icons --}}
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="57x57" href="{{ asset('favicon.png') }}">

    {{-- Microsoft Tiles --}}
    <meta name="msapplication-TileImage" content="{{ asset('favicon.png') }}">
    <meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:description" content="{{ $metatags['og_description'] ?? ($metatags['description'] ?? '') }}">
    @php
        // Use the same canonical URL logic for Open Graph
        $currentUrl = url()->current();
        $ogUrl = $currentUrl;

        // Remove language prefix if it exists
        if (app()->getLocale() !== config('app.fallback_locale')) {
            $localePrefix = '/' . app()->getLocale();
            if (str_starts_with($currentUrl, $localePrefix)) {
                $ogUrl = str_replace($localePrefix, '', $currentUrl);
            }
        }

        $ogUrl = rtrim($ogUrl, '/');
        if (empty($ogUrl)) {
            $ogUrl = url('/');
        }
    @endphp
    <meta property="og:url" content="{{ $metatags['og_url'] ?? $ogUrl }}">
    <meta property="og:image" content="{{ $metatags['og_image'] ?? asset('images/default-og.jpg') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:type" content="{{ $metatags['og_type'] ?? 'website' }}">
    <meta property="og:site_name" content="{{ $metatags['og_site_name'] ?? config('settings.site_name') }}">
    <meta property="og:locale" content="{{ $metatags['og_locale'] ?? app()->getLocale() }}">

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $metatags['twitter_title'] ?? ($metatags['title'] ?? '') }}">
    <meta name="twitter:description"
        content="{{ $metatags['twitter_description'] ?? ($metatags['description'] ?? '') }}">
    <meta name="twitter:image" content="{{ $metatags['twitter_image'] ?? asset('images/default-og.jpg') }}">
    <meta name="twitter:url" content="{{ $metatags['twitter_url'] ?? $ogUrl }}">
    @if (!empty($metatags['twitter_site']))
        <meta name="twitter:site" content="{{ $metatags['twitter_site'] }}">
    @endif
    @if (!empty($metatags['twitter_creator']))
        <meta name="twitter:creator" content="{{ $metatags['twitter_creator'] }}">
    @endif

    {{-- Performance --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">

    {{-- Hreflang Tags --}}
    @php
        $locales = ['ar', 'en'];
        $currentPath = request()->path();
        $pathWithoutLocale = preg_replace('/^(ar|en|api)\/?/', '', $currentPath);

        // Check if this is a blog page
        if (preg_match('/^blogs\/(.+)$/', $pathWithoutLocale, $matches)) {
            $currentSlug = urldecode($matches[1]);

            // Try multiple methods to find the blog
            $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.ar') = ?", [$currentSlug])
                ->orWhereRaw("JSON_EXTRACT(slug, '$.en') = ?", [$currentSlug])
                ->first();

            // If not found with JSON_EXTRACT, try manual search
            if (!$blog) {
                $blogs = \App\Models\Blog::all();
                foreach ($blogs as $b) {
                    foreach (['ar', 'en'] as $lang) {
                        $blogSlug = $b->getTranslation('slug', $lang);
                        if ($blogSlug === $currentSlug) {
                            $blog = $b;
                            break 2;
                        }
                    }
                }
            }

            if ($blog) {
                foreach ($locales as $locale) {
                    $localizedUrl = $blog->getLocalizedUrl($locale);
                    if ($localizedUrl) {
                        echo '<link rel="alternate" hreflang="' . $locale . '" href="' . $localizedUrl . '" />';
                    }
                }
                // Add x-default pointing to Arabic (default language)
                $defaultUrl = $blog->getLocalizedUrl('ar');
                if ($defaultUrl) {
                    echo '<link rel="alternate" hreflang="x-default" href="' . $defaultUrl . '" />';
                }
            } else {
                // Fallback to simple method if blog not found
                $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
                foreach ($locales as $locale) {
                    echo '<link rel="alternate" hreflang="' .
                        $locale .
                        '" href="' .
                        url('/' . $locale . $path) .
                        '" />';
                }
                // Add x-default pointing to Arabic
                echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
            }
        } else {
            // For non-blog pages, use the simple method
            $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
            foreach ($locales as $locale) {
                echo '<link rel="alternate" hreflang="' . $locale . '" href="' . url('/' . $locale . $path) . '" />';
            }
            // Add x-default pointing to Arabic
            echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
        }
    @endphp


   

@endif

{{-- Schema JSON-LD --}}
@if (!empty($schema))
    <script type="application/ld+json">
{!! json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@else
    {{-- Default WebPage Schema (safe encoding) --}}
    @php
        // Use the same canonical URL logic for schema
        $currentUrl = url()->current();
        $schemaUrl = $currentUrl;

        // Remove language prefix if it exists
        if (app()->getLocale() !== config('app.fallback_locale')) {
            $localePrefix = '/' . app()->getLocale();
            if (str_starts_with($currentUrl, $localePrefix)) {
                $schemaUrl = str_replace($localePrefix, '', $currentUrl);
            }
        }

        $schemaUrl = rtrim($schemaUrl, '/');
        if (empty($schemaUrl)) {
            $schemaUrl = url('/');
        }
    @endphp
    <script type="application/ld+json">
{!! json_encode([
        '@context' => 'https://schema.org',
        '@type' => 'WebPage',
        'name' => $metatags['title'] ?? config('settings.site_name'),
        'url' => $metatags['canonical'] ?? $schemaUrl,
        'description' => $metatags['description'] ?? ''
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- FAQ Schema --}}
@if (!empty($faq_schema))
    <script type="application/ld+json">
    {!! json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Breadcrumb Schema --}}
@if (!empty($breadcrumb_schema))
    <script type="application/ld+json">
    {!! json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif





{{-- Default Schema for Organization and Website --}}
@if (empty($schema))
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ config('settings.site_name') ?? 'ميبيكوم' }}",
        "url": "{{ url('/') }}",
        "logo": "{{ asset('assets/website/images/logo.png') }}",
        "description": "{{ config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة' }}",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
    </script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "{{ config('settings.site_name') ?? 'ميبيكوم' }}",
        "url": "{{ url('/') }}",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "{{ url('/') }}?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
    </script>
@endif


