@if ($blogs->isNotEmpty())
    <!--===============Blogs==============-->
    <section class="news-section sec-pad pt-5">
        <div class="container">
            <div class="row clearfix">
                @foreach ($blogs as $blog)
                    <div class="col-lg-4 col-md-6 col-sm-12 news-block">
                        <div class="news-block-one">
                            <div class="inner-box">
                                <figure class="image-box">
                                    <a href="{{ $blog->link }}" aria-label="blogs">
                                        <div class="img-div lazy-div">
                                            <img class="lazy img" data-src="{{ $blog->image_path }}"
                                                data-srcset="{{ $blog->image_path }}" alt="{{ $blog->name }}"
                                                width="350" height="250">
                                            <div class="next-lazy-img"></div>
                                    </a>
                                </figure>
                                <div class="lower-content">
                                    <h3><a href="{{ $blog->link }}" aria-label="title">{{ $blog->name }}</a></h3>
                                    <p>{{ \Illuminate\Support\Str::limit(strip_tags((string) $blog->short_desc), 100) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>

            {{-- Pagination --}}
            @if ($blogs->hasPages())
                <div class="row">
                    <div class="col-12">
                        <div class="pagination-wrapper text-center mt-5">
                            {{-- Pagination Info --}}
                            <div class="pagination-info mb-3">
                                {{ __('website.pagination.showing') }} <strong>{{ $blogs->firstItem() }}</strong>
                                {{ __('website.pagination.to') }} <strong>{{ $blogs->lastItem() }}</strong>
                                {{ __('website.pagination.of') }} <strong>{{ $blogs->total() }}</strong>
                                {{ __('website.pagination.results') }}
                            </div>

                            {{-- Pagination Links --}}
                            {{ $blogs->appends(request()->query())->links('pagination::custom') }}
                        </div>
                    </div>
                </div>
            @endif

        </div>
    </section>
    <!--===============Blogs==============-->
@endif
