@if ($services->isNotEmpty())
    <!--==========================Services==========================-->
    <section class="services-section sec-pad">
        <div class="container">
            <div class="upper-box">
                @foreach ($sections as $key => $section)
                    @if ($section->key == 'services')
                        <div class="sec-title">
                            <span class="sub-title">{{ $section->name }}</span>
                            <h2 class="border-bottom">{{ $section->title }}</h2>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="row clearfix">
                @foreach ($services as $service)
                    <div class="col-lg-4 col-md-6 col-sm-12 services-block">
                        <div class="services-block-one">
                            <div class="inner-box">
                                <div class="image-box">
                                    <a href="{{ $service->link }}" aria-label="imglink">
                                        <div class="img-div lazy-div">
                                            <img class="lazy img" data-src="{{ $service->image_path }}"
                                                data-srcset="{{ $service->image_path }}" alt="{{ $service->name }}"
                                                width="350" height="250">
                                            <div class="next-lazy-img"></div>
                                        </div>
                                    </a>
                                </div>
                                <div class="lower-content">
                                    <h3><a href="{{ $service->link }}" aria-label="service">{{ $service->name }}</a>
                                    </h3>
                                    <p>{{ \Illuminate\Support\Str::limit($service->short_desc, 100) }}</p>
                                    <div class="link">
                                        <a href="{{ $service->link }}"
                                            aria-label="readMore">{{ __('website.read_more') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                <div class="col-12 mt-5 centred">
                    <div class="btn-box">
                        <a href="{{ Path::AppUrl('services') }}" class="theme-btn btn-one"
                            aria-label="services">{{ __('website.all_services') }}</a>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </section>
    <!--==========================Services==========================-->
@endif
