
<section class="product-section py-5 wow fadeInUp" data-wow-delay="0.2s">
    <div class="container py-5">
        <div class="row align-items-center g-5 mt-5">

            <div class="col-lg-4 wow fadeInRight" data-wow-delay="0.6s">
                @foreach ($sections as $section)
                    @if ($section->key == 'products')
                        <div class="header">
                            <h2 class="fw-bold mb-3 text-nowrap">{{ $section->title }}</h2>
                            <p class="mb-4">
                                {{ $section->second_title }}
                            </p>
                        </div>
                        @break
                    @endif
                @endforeach

                <div class="mt-4 wow fadeInUp" data-wow-delay="1.6s">
                    <a href="{{ Path::AppUrl('products') }}" class="btn btn-send py-3 px-5 shadow-sm">@lang('website.view_all_products')</a>
                </div>
            </div>

            <!-- الكاروسيل -->
            <div class="col-lg-8 text-center wow fadeInLeft position-relative" data-wow-delay="0.4s">
                <div class="owl-carousel owl-theme product-owl">
                    <!-- Card 1 -->
                    @foreach ($products as $product)    
                        <div class="item py-2">
                            <div class="card product-card border-0 h-100">
                                <a href="{{ $product->link }}">
                                    <div class="card-img-wrapper">
                                        <img src="{{ $product->image_path }}" class="w-100 object-fit-cover" alt="{{ $product->name }}" />
                                        <!-- Overlay -->
                                        <div class="overlay">
                                            <h5 class="overlay-title">{{ $product->name }}</h5>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
