<x-dashboard.layout :title="__('dashboard.add_team')">

    <!-- Page Header -->
    <x-dashboard.partials.page-header 
        :header="__('dashboard.add_team')" 
        :label_url="route('dashboard.teams.index')" 
        :label="__('dashboard.teams')" 
    />
    <!-- End Page Header -->

    <!-- Row -->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-header">
                    <h4 class="card-title">{{ __('dashboard.add_team') }}</h4>
                </div>

                <div class="card-body">
                    <form action="{{ route('dashboard.teams.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">

                            <!-- Multilingual Name Fields -->
                            <x-dashboard.multilingual-input 
                                name="name" 
                                type="text" 
                                :required="true" 
                                label="{{ __('dashboard.name') }}" 
                            />

                            <!-- Multilingual Position Fields -->
                            <x-dashboard.multilingual-input 
                                name="position" 
                                type="text" 
                                :required="true" 
                                label="{{ __('dashboard.position') }}" 
                            />

                            <!-- Social Links -->
                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.facebook') }}</label>
                                <input type="url" name="facebook" class="form-control" value="{{ old('facebook') }}" placeholder="https://facebook.com/...">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.twitter') }}</label>
                                <input type="url" name="twitter" class="form-control" value="{{ old('twitter') }}" placeholder="https://twitter.com/...">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.instagram') }}</label>
                                <input type="url" name="instagram" class="form-control" value="{{ old('instagram') }}" placeholder="https://instagram.com/...">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.tiktok') }}</label>
                                <input type="url" name="tiktok" class="form-control" value="{{ old('tiktok') }}" placeholder="https://tiktok.com/...">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.youtube') }}</label>
                                <input type="url" name="youtube" class="form-control" value="{{ old('youtube') }}" placeholder="https://youtube.com/...">
                            </div>

                            <!-- Image Upload -->
                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.image') }} (800px * 800px max 2MB)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                            </div>

                            <!-- Alt Image -->
                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text" value="{{ old('alt_image') }}" placeholder="{{ __('dashboard.alt_image') }}">
                            </div>

                            <!-- Status -->
                            <div class="form-group col-md-4 mt-3 mb-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }}</h5>
                                    <input type="checkbox" id="switch1" switch="none" value="1" name="status" checked />
                                    <label for="switch1" data-on-label="{{ __('dashboard.yes') }}" data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>

                            <!-- Buttons -->
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="icon-note"></i> {{ __('dashboard.save') }}
                                </button>

                                <a href="{{ route('dashboard.teams.index') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                                    </button>
                                </a>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

</x-dashboard.layout>
