<x-dashboard.layout :title="__('dashboard.ai_content')">

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <h4 class="mb-0">Details of the generated content</h4>
                    <div class="page-title-right">
                        <a href="{{ route('dashboard.ai-content.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <!-- تفاصيل المحتوى -->
                <div class="enhanced-page-header">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Details of the content</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Title</label>
                                    <p class="form-control-plaintext">{{ $content->title ?: 'No title' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Type</label>
                                    <p class="form-control-plaintext">
                                        <span class="badge bg-primary">{{ $content->type }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Content</label>
                            <div class="border rounded p-3 bg-light">
                                {!! nl2br(e($content->content)) !!}
                            </div>
                        </div>

                        @if ($content->meta_description)
                            <div class="mb-3">
                                <label class="form-label fw-bold">Short description</label>
                                <p class="form-control-plaintext">{{ $content->meta_description }}</p>
                            </div>
                        @endif

                        @if ($content->keywords)
                            <div class="mb-3">
                                <label class="form-label fw-bold">Keywords</label>
                                <p class="form-control-plaintext">{{ $content->keywords }}</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- معلومات التوليد -->
                <div class="enhanced-page-header">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Generation information</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Status</label>
                            <p class="form-control-plaintext">
                                @if ($content->status === 'active')
                                    <span class="badge bg-success">Active</span>
                                @elseif($content->status === 'inactive')
                                    <span class="badge bg-secondary">Inactive</span>
                                @else
                                    <span class="badge bg-warning">Draft</span>
                                @endif
                            </p>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Generated by</label>
                            <p class="form-control-plaintext">{{ $content->admin->name ?? 'Not defined' }}</p>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Creation date</label>
                            <p class="form-control-plaintext">{{ $content->created_at->format('Y-m-d H:i:s') }}</p>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Number of words</label>
                            <p class="form-control-plaintext">{{ $content->word_count }}</p>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Cost</label>
                            <p class="form-control-plaintext">${{ number_format($content->cost, 4) }}</p>
                        </div>

                        @if ($content->model_used)
                            <div class="mb-3">
                                <label class="form-label fw-bold">Used model</label>
                                <p class="form-control-plaintext">{{ $content->model_used }}</p>
                            </div>
                        @endif

                        @if ($content->generation_time)
                            <div class="mb-3">
                                <label class="form-label fw-bold">Generation time</label>
                                <p class="form-control-plaintext">{{ $content->formatted_generation_time }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- النص المطلوب -->
                <div class="enhanced-page-header">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Required text</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Prompt</label>
                            <div class="border rounded p-3 bg-light">
                                {{ $content->prompt }}
                            </div>
                        </div>

                        @if ($content->options)
                            <div class="mb-3">
                                <label class="form-label fw-bold">Used options</label>
                                <div class="border rounded p-3 bg-light">
                                    <pre class="mb-0">{{ json_encode($content->options, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- معلومات الاستخدام -->
                @if ($content->usage_data)
                    <div class="enhanced-page-header">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Usage information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @if (isset($content->usage_data['prompt_tokens']))
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Prompt Tokens</label>
                                            <p class="form-control-plaintext">
                                                {{ $content->usage_data['prompt_tokens'] }}</p>
                                        </div>
                                    </div>
                                @endif

                                @if (isset($content->usage_data['completion_tokens']))
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Completion Tokens</label>
                                            <p class="form-control-plaintext">
                                                {{ $content->usage_data['completion_tokens'] }}</p>
                                        </div>
                                    </div>
                                @endif

                                @if (isset($content->usage_data['total_tokens']))
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Total Tokens</label>
                                            <p class="form-control-plaintext">
                                                {{ $content->usage_data['total_tokens'] }}</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- الإجراءات -->
        <div class="row">
            <div class="col-12">
                <div class="enhanced-page-header">
                    <div class="card-header">
                        <h5 class="card-title mb-0">الإجراءات</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-success" onclick="updateStatus('active')">
                                <i class="fas fa-check"></i> Activate
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="updateStatus('inactive')">
                                <i class="fas fa-pause"></i> Stop
                            </button>
                            <button type="button" class="btn btn-warning" onclick="updateStatus('draft')">
                                <i class="fas fa-edit"></i> Draft
                            </button>
                            <button type="button" class="btn btn-info" onclick="copyContent()">
                                <i class="fas fa-copy"></i> Copy the content
                            </button>
                            <button type="button" class="btn btn-primary" onclick="editContent()">
                                <i class="fas fa-edit"></i> Edit
                            </button>
                            <button type="button" class="btn btn-danger" onclick="deleteContent()">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal لتحديث الحالة -->
    <div class="modal fade" id="updateStatusModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update content status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to update the status of this content?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="confirmUpdateStatus">Confirm</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal للحذف -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete content</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this content? This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Delete</button>
                </div>
            </div>
        </div>
    </div>
</x-dashboard.layout>
@push('scripts')
    <script>
        let currentStatus = null;

        function updateStatus(status) {
            currentStatus = status;
            $('#updateStatusModal').modal('show');
        }

        function deleteContent() {
            $('#deleteModal').modal('show');
        }

        function copyContent() {
            const content = `{{ $content->content }}`;
            navigator.clipboard.writeText(content).then(function() {
                showAlert('The content has been copied to the clipboard', 'success');
            }, function() {
                showAlert('Failed to copy the content', 'danger');
            });
        }

        function editContent() {
            // يمكن إضافة منطق لتعديل المحتوى
            showAlert('Editing feature is under development', 'info');
        }

        $('#confirmUpdateStatus').click(function() {
            if (currentStatus) {
                $.ajax({
                    url: '{{ route('dashboard.ai-content.update-status', $content->id) }}',
                    method: 'PUT',
                    data: {
                        status: currentStatus,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            location.reload();
                        } else {
                            showAlert('An error occurred while updating the status', 'danger');
                        }
                    },
                    error: function() {
                        showAlert('An error occurred while updating the status', 'danger');
                    }
                });
            }
            $('#updateStatusModal').modal('hide');
        });

        $('#confirmDelete').click(function() {
            window.location.href = '{{ route('dashboard.ai-content.destroy', $content->id) }}';
            $('#deleteModal').modal('hide');
        });

        function showAlert(message, type) {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

            document.querySelector('.container-fluid').insertBefore(alertDiv, document.querySelector('.row'));

            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
        }
    </script>
@endpush
