<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('site_addresses', function (Blueprint $table) {
            $table->json('opening_days')->nullable();
            $table->json('closing_days')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('site_addresses', function (Blueprint $table) {
            $table->dropColumn(['opening_days', 'closing_days']);
        });
    }
};
