<?php

namespace App\Services\Dashboard;

use App\Helper\Media;
use App\Models\Feature;
use App\Services\JsonTranslationService;
use Illuminate\Support\Facades\DB;

class FeatureService
{
    public function store($request)
    {
        $data = $request->validated();

        DB::beginTransaction();
        try {
            // Handle file uploads
            if ($request->hasFile('icon')) {
                $data['icon'] = Media::uploadAndAttachImageStorage($request->file('icon'), 'features');
            }

            // Prepare main model data
            $mainData = [
                'counter' => $data['counter'] ?? null,
                'icon' => $data['icon'] ?? null,
                'alt_icon' => $data['alt_icon'] ?? null,
                'status' => $data['status'] ?? 0,
            ];

            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('feature');

            // Create model with JSON translations
            $feature = JsonTranslationService::createWithTranslations(Feature::class, $mainData, $request, $translationFields);

            DB::commit();
            return $feature;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function update($request, $feature)
    {
        $data = $request->validated();

        DB::beginTransaction();

        try {
            // Handle file uploads
           

            if ($request->hasFile('icon')) {
                if ($feature->icon) {
                    Media::removeFile('features', $feature->icon);
                }
                $data['icon'] = Media::uploadAndAttachImageStorage($request->file('icon'), 'features');
            }

            // Prepare main model data
            $mainData = [
                'counter' => $data['counter'] ?? $feature->counter,
                'icon' => $data['icon'] ?? $feature->icon,
                'alt_icon' => $data['alt_icon'] ?? $feature->alt_icon,
                'status' => $data['status'] ?? $feature->status,
                
            ];

            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('feature');

            // Update model with JSON translations
            $feature = JsonTranslationService::updateWithTranslations($feature, $mainData, $request, $translationFields);

            DB::commit();
            return $feature;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }


    public function delete($selectedIds)
    {
        $features = Feature::whereIn('id', $selectedIds)->get();

        DB::beginTransaction();
        try {
            foreach ($features as $feature) {
 

                // Delete associated Icon if it exists
                if ($feature->icon) {
                    Media::removeFile('features', $feature->icon);
                }

                // Delete the feature model (this triggers the observer)
                $feature->delete();
            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
