<?php

namespace App\Models;

use App\Traits\HasJsonTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    use HasFactory , HasJsonTranslations;

    protected $fillable = [
        'name_ar',
        'name_en',
        'position_ar',
        'position_en',
        'facebook',
        'twitter',
        'instagram',
        'tiktok',
        'youtube',
        'image',
        'alt_image',
        'status',

    ];
    protected $casts = [
        'name' => 'array',
        'position' => 'array',
    ];

    public function getNameAttribute()
    {
        $locale = app()->getLocale();
        return $this->getTranslatableAttribute('name');
    }

    public function getPositionAttribute()
    {
        return $this->getTranslatableAttribute('position');    }

    public function getImagePathAttribute()
    {
        return $this->image ? asset('storage/teams/' . $this->image) : asset('assets/dashboard/images/noimage.png');
    }

    public function scopeActive($query){
        $query->whereStatus(1);
    }


}
