<?php

namespace App\Models;

use App\Traits\HasJsonTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Testing\Fluent\Concerns\Has;

class Benefit extends Model
{
    use HasFactory, HasJsonTranslations;
    protected $table = 'benefits';
    protected $fillable = [
        'benefitable_id',
        'benefitable_type',
        'title_en',
        'title_fr',
        'title_ar',
        'short_description_en',
        'short_description_ar',
        'long_description_en',
        'long_description_ar',
        'image',
        'icon',
        'status',
        'order',
        'alt_image',
        'alt_icon',
        'name',
        'description',
    ];


    protected $casts = [
        'name' => 'array',
        'description' => 'array',
    ];
    public function benefitable()
    {
        return $this->morphTo();
    }
    
    public function benefits()
    {
        return $this->morphMany(self::class , 'benefitable')->whereStatus(1);
    }
    
    public function product()
    {
        return $this->belongsTo(Product::class );
    }
    public function childBenefits(){
        $this->morphMany(self::class,'benefitable' );
    }

    public function getImagePathAttribute()
    {
        return $this->image ? asset('storage/benefits/' . $this->image) : asset('assets/dashboard/images/noimage.png');;
    }

    public function getIconPathAttribute()
    {
        return $this->icon ? asset('storage/benefits/' . $this->icon) : asset('assets/dashboard/images/noimage.png');
    }
    
    public function getApiImageAttribute()
    {
        return $this->image ? asset('storage/benefits/' . $this->image) : null;
    }

    public function getApiIconAttribute()
    {
        return $this->icon ? asset('storage/benefits/' . $this->icon) : null;
    }
    public function getTitleAttribute()
    {
        return $this->{'title_' . app()->getLocale()};
    }
    public function getShortDescAttribute()
    {
        return $this->{'short_description_' . app()->getLocale()};
    }
    public function getLongDescAttribute()
    {
        return $this->{'long_description_' . app()->getLocale()};
    }

    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    public function scopeGeneral($query)
    {
        return $query->where('benefitable_type', null);
    }
}
