<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'short_desc' => $this->short_desc,
            'long_desc' => $this->long_desc,
            'image' => $this->image_path,
            'alt_image' => $this->alt_image,
            'icon' => $this->icon_path,
            'alt_icon'=>$this->alt_icon,
            'slug' => $this->slug_lang,

        ];
    }
}
