<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BenefitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        return [
            'id' => $this->id,
            'title' => $this->title,
            'short_description' => $this->short_desc,
            'long_description' => $this->long_desc,

            'image' => $this->api_image ,
            'alt_image' => $this->alt_image,
            'icon' => $this->api_icon ,
            'alt_icon' => $this->alt_icon,
            // 'name' => $this->name,
            // 'description' => $this->description,
            'benefits' =>  BenefitResource::collection($this->benefits)
            

        ];
    }
}
