<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FeatureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title_ar'  => 'required|string|max:255',
            'title_en' => 'required|string|max:255', // example: title['en'], title['ar']
            'text_en'    => 'required|string',
            'text_ar'    => 'required|string',
            'counter' => 'required|string|max:255',
            'icon'    => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048',
        ];
    }
}
