<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use App\Http\Resources\ServiceResource;
use App\Models\Section;
use App\Models\Service;
use Illuminate\Http\Request;
use App\View\Composers\SeoComposer ;


class ProjectController extends Controller
{
     private $sections ;
    public function __construct(){
        $this->sections = Section::get();
    }
    public function index()
    {
        SeoComposer::renderSeo();

        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
                'projects' => $this->getServicesSection(),
            ]
        ];

        return response()->json(
            $data ,
            200,
            
        );
    }




    public function getServicesSection()
    {
        $section = $this->sections->firstWhere('key' , 'services');
        $services = Service::active()->get();

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc ?? null,
            'data' => ServiceResource::collection($services)

        ];
    }

   
}
