<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use App\Http\Resources\AboutStructResource;
use App\Http\Resources\AboutUSResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\FeatureResource;
use App\Http\Resources\PartnerResource;
use App\Http\Resources\ProjectResource;
use App\Http\Resources\ServiceResource;
use App\Http\Resources\SliderResource;
use App\Models\Category;
use App\Models\Dashboard\AboutStruct;
use App\Models\Dashboard\AboutUs;
use App\Models\Feature;
use App\Models\Partener;
use App\Models\Project;
use App\Models\Section;
use App\Models\Service;
use App\Models\Slider;
use App\View\Composers\SeoComposer ;


class HomeController    extends Controller 
{

    private $sections ;
    public function __construct(){
        $this->sections = Section::get();
    }
    public function index()
    {
        SeoComposer::renderSeo();


        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
            'sliders' => $this->getSlidersSection() ,
            'about' => $this->getAboutSection(),
            'about_structs' => $this->getAboutStructsSection(),
            'features' => $this->getFeaturesSection(),
            'partners' => $this->getPartnersSection(),
            'services' => $this->getServicesSection(),
            'categories' => $this->getCategoriesSection(),
            'contact' => $this->getContactUsSection(),
            'projects' => $this->getProjectsSection(),
            ]
        ];

        return response()->json(
            $data ,
            200,
            
        );
    }

    public function  getSlidersSection()
    {
        $sliders = Slider::active()->get();
        return  ['data' => SliderResource::collection($sliders)];
    }
    public function getAboutSection()
    {
        $about = AboutUs::first();
        return ['data' => $about ? new AboutUSResource($about): null ];

    }

    public function getAboutStructsSection(){
        $struct = AboutStruct::active()->get();
        return ['data' => AboutStructResource::collection($struct)];
    }

    public function getFeaturesSection()
    {
        $feature = Feature::active()->get();
        return  ['data' => FeatureResource::collection($feature)];

    }

    public function getPartnersSection()
    {
        $section = $this->sections->firstWhere('key' , 'partners');
        $partners = Partener::active()->get();

        return [
            'title' => $section->title ?? null,
            'short_desc' => $section->short_desc ?? null,
            'data' => PartnerResource::collection($partners)

        ];
    }


    public function getServicesSection()
    {
        $section = $this->sections->firstWhere('key' , 'services');
        $services = Service::active()->get();

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc ?? null,
            'data' => ServiceResource::collection($services)

        ];
    }


    public function getProjectsSection()
    {
        $section = $this->sections->firstWhere('key' , 'projects');
        $projects = Project::active()->get();

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc ?? null,
            'data' => ProjectResource::collection($projects)

        ];
    }

    public function getCategoriesSection()
    {
        $section = $this->sections->firstWhere('key' , 'products');
        $category = Category::active()->get();

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc?? null,
            'data' => CategoryResource::collection($category)

        ];
    }

    public function getContactUsSection()
    {
        $section = $this->sections->firstWhere('key' , 'contact');

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc?? null,
        ];
    }
}