<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use App\Http\Requests\Website\StoreContactUsRequest;
use App\Http\Resources\SiteAddressResource;
use App\Models\ContactUs;
use App\Models\Section;
use App\Models\SiteAddress;
use App\View\Composers\SeoComposer ;


class ContactController extends Controller
{
     private $sections ;
    public function __construct(){
        $this->sections = Section::get();
    }
    public function index()
    {
        SeoComposer::renderSeo();

        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
                'contact' => $this->getContactUsSection(),
            ]
        ];

        return response()->json(
            $data ,
            200,
            
        );
    }

    public function getContactUsSection()
    {
        $section = $this->sections->firstWhere('key' , 'contact');

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc?? null,
            'data' => new SiteAddressResource(SiteAddress::first())
        ];
    }


    public function store(StoreContactUsRequest $request)
    {
       $data = $request->validated();
       ContactUs::create($data);
       return response()->json([
        'success' => true,
        'message' => __('website.thanks_message'),
        'data' => []
       ]);
    }
}
